%% Panda BEVintage
% VPE_s1 input data
close all
clear all
clc

%% Vehicle Body Total Load (Computed)
m_e = 1.0359e+03;
c_0 = 145.0911;
c_1 = 0;
c_2 = 0.4764;
g = 9.81;

%% Mapped Motor
% Electrical Torque - Nominal & Maximal
w_n = 2895 /60*2*pi;
T_m_n = 40;
eta_n = 0.91 *100; %@ w_n & T_m_n
P_m_n = w_n * T_m_n
T_m_max = 66;
P_m_max = w_n*T_m_max*1.1
tau_m = 0.02;
% Electrical Losses - Single Efficiency
Pl_iron = 0; %IPM
Pl_eln = 100;
Pl_copper_n = (1-eta_n/100)*P_m_n -Pl_eln -Pl_iron
k_T = Pl_copper_n /T_m_n^2
% Mechanical
J_m = .005e-3;
beta_m = 1e-5;

%% Transmission
r_e = 0.27;
T_r = 8.67;

%% Longitudinal Driver
V_max = 120 /3.6;
K_p = 15;
K_i = 1;
K_aw = 0.1;
K_ff = 0.05;
K_g = 0.01;
tau_e = 0.03;

%% Battery
V_DC = 96;
%% Enhanced Model-ADC-Specifications

%Sampling Time:
Sampling_Time=0.0001 %

%Number of bits:
Bits=16        %16 bits ADC and DAC from DataSheet


%MotorSpeed
%Signal Specifications:

Max_Speed=400*pi
Min_Speed=-400*pi
Full_Speed_Range=Max_Speed-Min_Speed

%LinearTransducer -SpeedSensor
%COnverting to MotorSpeed to Voltage from -5V to 5V 
MaxOutputSpeedSensor=5
MinOutputSpeedSensor=-5   

%Scaling (Adjusting the input of the Reference Signal to board Dynamics
%-10 - +10V
%Maximum and minimum analog voltages that can be applied to board
Anglog_Input_Min=-10  %in Volts
Anglog_Input_Max=10  %in Volts
%ADC and DAC of board has range of -10V to 10V from DataSheet

%Full Scale Reading( Maximum-Minimum):
Full_Scale_Reading=Anglog_Input_Max-Anglog_Input_Min
    
%% Enhanced Model-DAC-Specifications
%ADC and DAC of board has range of -10V to 10V from DataSheet
Anglog_Output_Min=-10  %in Volts
Anglog_Output_Max=10  %in Volts
%Full Scale Reading( Maximum-Minimum):
Full_ScaleDAC_Reading=Anglog_Output_Max-Anglog_Output_Min

%FOH Time:
FOH_Time=0.001 %
%ZOH Time:
ZOH_Time=0.0001 %

%BenchTorque
%Signal Specifications:

Max_BTrq=T_m_max
Min_BTrq=-T_m_max
Full_BTrq_Range=Max_BTrq-Min_BTrq

%LinearActuator -BenchTrqCmd
%COnverting Voltage to BTrq from -5V to 5V 
MaxInputBTrq=5
MinInputBTrq=-5   





